#ifndef __NeptuneScene_H__
#define __NeptuneScene_H__

#include "NeptuneCommon.h"
//#include "NeptuneHost.h"

NEPLIB_NS_START

class CNeptuneHost;
//class CMglLayer;

//	NX錾
class NEPDLL_EXP CNeptuneScene
{
private:
	CNeptuneHost* m_pHost;
	//CMglLayer* m_pMglLayer;
	void* m_pInternal;
	//std::map<std::string,int> m_layerNameMap;
	int m_nFrameCounter;

public:	//	 Ƃ肠JNIppublicɂĂEEEiprotected

	//###### gp\Ȋ֐ ########################################//


	//++++ 摜֘A +++++++++++++++++++++++++

	void LoadImageToPool(const char* szImageFilePath, const char* szImageName);	//	摜t@Cv[ɓǂݍ



	//	C[ǉ
	void AddImageLayer(const char* szImageName,
		float x=0.0f, float y=0.0f, bool bShow=true, NEPTUNE_COLOR color=NEPCOLOR_WHITE, 
		float fScaleX=1.0f, float fScaleY=1.0f, float fAngle=0.0f);
	//	 const char* szLayerName ̒ǉ炭Kv

	void AddFadeInImageLayer(const char* szImageName, int nFrameCount,
		float x=0.0f, float y=0.0f, bool bShow=true,
		float fScaleX=1.0f, float fScaleY=1.0f, float fAngle=0.0f);

	void AddFadeOutImageLayer(const char* szImageName, int nFrameCount,
		float x=0.0f, float y=0.0f, bool bShow=true,
		float fScaleX=1.0f, float fScaleY=1.0f, float fAngle=0.0f);

	/*
	void CNeptuneScene::AddLayer(CMglLayerBase4* pLayer, CMglLayers4::LIST_ITR it, bool isShouldDeleteLayer,
		float x=0.0f, float y=0.0f, bool bShow=true, NEPTUNE_COLOR color=NEPCOLOR_WHITE, 
		float fScaleX=1.0f, float fScaleY=1.0f, float fAngle=0.0f);
	*/

	//	C[폜
	void RemoveLayer(const char* szLayerName);



	//	C[ړ
	void MoveLayer(const char* szLayerName, float x=0.0f, float y=0.0f);
	//	int depth낤EEEH

	//	C[\/\ɂ
	void HideLayer(const char* szLayerName);
	void ShowLayer(const char* szLayerName);

	//	C[p[^ݒ肷
	void SetLayerParam(const char* szLayerName, NEPTUNE_COLOR color=NEPCOLOR_WHITE, 
		float fScaleX=1.0f, float fScaleY=1.0f, float fAngle=0.0f);

	/*
	void FadeInLayer(const char* szLayerName);
	void FadeOutLayer(const char* szLayerName);
	*/

	//++++  +++++++++++++++++++++++++

	void PlayMusic(const char* szFilePath);
	void FadeOutMusic();
	void StopMusic();

	void LoadSound(const char* szFilePath, const char* szSoundName);
	void PlaySound(const char* szSoundName);


	//++++ ̑ +++++++++++++++++++++++++

	//	ʂ̃V[Ăт
	void SetWindowTitle(const char* szWindowTitle);

	//	ʂ̃V[Ăт
	bool CallScene(CNeptuneScene *pNextScene);
	//int CallScene(CNeptuneScene *pNextScene); <- ߂KwԂȂƂ߂H


	//#############################################################//

public:
	//	RXgN^EfXgN^
	CNeptuneScene();
	virtual ~CNeptuneScene();

	bool Start(CNeptuneHost *pHost);
	
	//	[U郁\bh
	virtual bool UserInitializeLogic()=0;
	virtual bool UserFinalizeLogic()=0;
	virtual bool UserOneFrameLogic()=0;

	virtual bool OnKeyEventHandler(BYTE onKeyArray[]);
	virtual bool OnMouseEventHandler(int type, long value){ return true; }
};

NEPLIB_NS_END

#endif//__NeptuneScene_H__
